---
title: "module salix::demo::basic::Celsius"
id: Celsius
slug: /Packages/org.rascalmpl.salix-core/API/salix/demo/basic/Celsius
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.2</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.salix-core-0.2.9</div>

#### Usage

```rascal
import salix::demo::basic::Celsius;
```

#### Dependencies
```rascal
import salix::App;
import salix::HTML;
import salix::Index;
import String;
import util::Math;
import Exception;
import salix::util::Debug;
```


## alias Model {#salix-demo-basic-Celsius-Model}

```rascal
real
```

## data Msg {#salix-demo-basic-Celsius-Msg}

```rascal
data Msg  
     = c(str c)
     | f(str f)
     ;
```

## function celsiusApp {#salix-demo-basic-Celsius-celsiusApp}

```rascal
SalixApp[Model] celsiusApp(str id = "root") 
  = makeApp(id, init, withIndex("C2F", id, view), update);
```

## function celsiusWebApp {#salix-demo-basic-Celsius-celsiusWebApp}

```rascal
App[Model] celsiusWebApp() 
  = webApp(
      celsiusApp(),
      |project://salix/src/main/rascal|
    );
```

## function init {#salix-demo-basic-Celsius-init}

```rascal
Model init() = 37.0;
```

## function debugCelsiusView {#salix-demo-basic-Celsius-debugCelsiusView}

```rascal
void debugCelsiusView(DebugModel[Model] m) {
  debugView(m, view);
}
```

## function debugCelsius {#salix-demo-basic-Celsius-debugCelsius}

```rascal
App[DebugModel[Model]] debugCelsius() 
  = debug("celsius"
    , Model() { return 37.0; }
    , void(DebugModel[Model] m) { ; }
    , Model(Msg x, Model m) { return m; }
    , |project://salix/src/main/rascal|);
```

## function view {#salix-demo-basic-Celsius-view}

```rascal
void view(Model m) {   
    h2("Celsius to fahrenheit converter");
    p(() {
      text("C: "); 
      input(\value("<round(m)>"),\type("number"), onInput(c));
    });
    p(() {
      text("F: ");
      input(\value("<round(toF(m))>"),\type("number"), onInput(f));
    });
}
```

## function toF {#salix-demo-basic-Celsius-toF}

```rascal
real toF(real c) = c * 9.0/5.0 + 32.0;
```

## function toC {#salix-demo-basic-Celsius-toC}

```rascal
real toC(real f) = (f - 32.0) * 5.0/9.0;
```

## function toReal_ {#salix-demo-basic-Celsius-toReal_}

```rascal
real toReal_(str s) {
  try {
    return toReal(s);
  }
  catch IllegalArgument():
    return 0.0;
}
```

## function update {#salix-demo-basic-Celsius-update}

```rascal
real update(Msg msg, Model model) {
  switch (msg) {
    case c(str new): model = toReal_(new);
    case f(str new): model = toC(toReal_(new));
  }
  return model;
}
```

