---
title: "module salix::demo::basic::Clock"
id: Clock
slug: /Packages/org.rascalmpl.salix-core/API/salix/demo/basic/Clock
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.2</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.salix-core-0.2.9</div>

#### Usage

```rascal
import salix::demo::basic::Clock;
```

#### Dependencies
```rascal
import salix::SVG;
import salix::HTML;
import salix::App;
import salix::Core;
import util::Math;
import salix::Index;
```


## function clockWebApp {#salix-demo-basic-Clock-clockWebApp}

```rascal
App[Model] clockWebApp() = webApp(clockApp(), |project://salix/src/main/rascal|);
```

## function clockApp {#salix-demo-basic-Clock-clockApp}

```rascal
SalixApp[Model] clockApp(str id = "root") 
  = makeApp(id, init, withIndex("Clock", id, view), update, subs=subs);
```

## alias Model {#salix-demo-basic-Clock-Model}

```rascal
tuple[int time, bool running]
```

## function init {#salix-demo-basic-Clock-init}

```rascal
Model init() = <1, false>;
```

## data Msg {#salix-demo-basic-Clock-Msg}

```rascal
data Msg  
     = tick(int time)
     | toggle()
     ;
```

## function subs {#salix-demo-basic-Clock-subs}

```rascal
list[Sub] subs(Model m) = [timeEvery(tick, 1000) | m.running ];
```

## function update {#salix-demo-basic-Clock-update}

```rascal
Model update(Msg msg, Model t) {
  switch (msg) {
   case tick(int time): t.time = time;
   case toggle(): t.running = !t.running;
  }
  return t;
}
```

## function view {#salix-demo-basic-Clock-view}

```rascal
void view(Model m) {
  h2("Clock using SVG");
  clock(m);
}
```

## function clock {#salix-demo-basic-Clock-clock}

```rascal
void clock(Model m) {
  real angle = 2 * PI() * (toReal(m.time) / 60.0);
  int handX = round(50 + 40 * cos(angle));
  int handY = round(50 + 40 * sin(angle));
  svg(viewBox("0 0 100 100"), width("300px"), () {
    circle(cx("50"), cy("50"), r("45"), fill("#0B79CE"));
    line(x1("50"), y1("50"), x2("<handX>"), y2("<handY>"), stroke("#023963"));
  }); 
  button(onClick(toggle()), "On/Off");
}
```

