---
title: "module salix::demo::basic::Files"
id: Files
slug: /Packages/org.rascalmpl.salix-core/API/salix/demo/basic/Files
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.2</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.salix-core-0.2.9</div>

#### Usage

```rascal
import salix::demo::basic::Files;
```

#### Dependencies
```rascal
import salix::App;
import salix::HTML;
import salix::Index;
import salix::Core;
import util::Maybe;
import IO;
```


## function filesApp {#salix-demo-basic-Files-filesApp}

```rascal
SalixApp[Model] filesApp(str id = "root") 
  = makeApp(id, init, withIndex("Files", id, view), update, subs = subs);
```

## function filesWebApp {#salix-demo-basic-Files-filesWebApp}

```rascal
App[Model] filesWebApp()
  = webApp(filesApp(),|project://salix-core/src/main/rascal|);
```

## function subs {#salix-demo-basic-Files-subs}

```rascal
list[Sub] subs(Model m) = [observeFile(fileChange, "it") | just(FSHandle fh) := m.theFile ];
```

## alias Model {#salix-demo-basic-Files-Model}

```rascal
tuple[Maybe[FSHandle] theFile, list[list[FSChange]] changes]
```

## function init {#salix-demo-basic-Files-init}

```rascal
Model init() = <nothing(), []>;
```

## data Msg {#salix-demo-basic-Files-Msg}

```rascal
data Msg  
     = fileOpened(FSHandle fh)
     | fileChange(list[FSChange] changes)
     | openFile()
     ;
```

## function update {#salix-demo-basic-Files-update}

```rascal
Model update(Msg msg, Model m) {
  switch (msg) {
    case openFile(): do(pickFile(fileOpened, "it"));
    case fileOpened(FSHandle fh): {
        println(fh);
        m.theFile = just(fh);
    } 
    case fileChange(list[FSChange] cs):
        m.changes += [cs];
  }
  return m;
}
```

## function view {#salix-demo-basic-Files-view}

```rascal
void view(Model m) {
  h2("Dealing with files");
  button(onClick(openFile()), "Open file...");
  div("<m.theFile>");

  ul(() {
    for (list[FSChange] cs <- m.changes) {
        li("<cs>");
    }
  });

}
```

