---
title: "module salix::demo::basic::Random"
id: Random
slug: /Packages/org.rascalmpl.salix-core/API/salix/demo/basic/Random
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.2</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.salix-core-0.2.9</div>

#### Usage

```rascal
import salix::demo::basic::Random;
```

#### Dependencies
```rascal
import salix::HTML;
import salix::Core;
import salix::App;
import salix::Index;
```


## function randomApp {#salix-demo-basic-Random-randomApp}

```rascal
SalixApp[Model] randomApp(str id = "root") 
  = makeApp(id, init, withIndex("Random", id, view), update);
```

## function randomWebApp {#salix-demo-basic-Random-randomWebApp}

```rascal
App[Model] randomWebApp() = webApp(randomApp(), |project://salix/src/main/rascal|);
```

## alias Model {#salix-demo-basic-Random-Model}

```rascal
tuple[int dieFace]
```

## function init {#salix-demo-basic-Random-init}

```rascal
Model init() = <1>;
```

## data Msg {#salix-demo-basic-Random-Msg}

```rascal
data Msg  
     = roll()
     | newFace(int face)
     ;
```

## function update {#salix-demo-basic-Random-update}

```rascal
Model update(Msg msg, Model m) {
  switch (msg) {    
    case roll():  do(random(newFace, 1, 6)); 
    case newFace(int n): m.dieFace = n; 
  }
  return m;
}
```

## function view {#salix-demo-basic-Random-view}

```rascal
void view(Model m) {
  button(onClick(roll()), "Roll");
  text(m.dieFace);
}
```

## function twiceWebApp {#salix-demo-basic-Random-twiceWebApp}

```rascal
App[TwiceModel] twiceWebApp()
  = webApp(
      makeApp("root", twiceInit, withIndex("Twice", "root", twiceView), twiceUpdate), 
      |project://salix/src/main/rascal|
    );
```

## function twiceInit {#salix-demo-basic-Random-twiceInit}

```rascal
TwiceModel twiceInit() = twice(init(), init());
```

## data TwiceModel {#salix-demo-basic-Random-TwiceModel}

```rascal
data TwiceModel  
     = twice(Model model1, Model model2)
     ;
```

## data Msg {#salix-demo-basic-Random-Msg}

```rascal
data Msg  
     = sub1(Msg msg)
     | sub2(Msg msg)
     ;
```

## function twiceUpdate {#salix-demo-basic-Random-twiceUpdate}

```rascal
TwiceModel twiceUpdate(Msg msg, TwiceModel m) {
  switch (msg) {
    case sub1(Msg s):
      m.model1 = mapCmds(sub1, s, m.model1, update);   
    case sub2(Msg s):
      m.model2 = mapCmds(sub2, s, m.model2, update);
  }
  return m;
}
```

## function twiceView {#salix-demo-basic-Random-twiceView}

```rascal
void twiceView(TwiceModel m) {
  h2("Two times roll a die");
  mapView(sub1, m.model1, view);
  mapView(sub2, m.model2, view);
}
```

