---
title: "module salix::util::Debug"
id: Debug
slug: /Packages/org.rascalmpl.salix-core/API/salix/util/Debug
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.2</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.salix-core-0.2.9</div>

#### Usage

```rascal
import salix::util::Debug;
```

#### Dependencies
```rascal
import salix::HTML;
import salix::App;
import salix::Core;
import salix::Index;
import List;
```


## alias DebugModel {#salix-util-Debug-DebugModel}

```rascal
tuple[int current, list[&T] models, list[Msg] messages, &T(Msg, &T) update]
```

## data Msg {#salix-util-Debug-Msg}

```rascal
data Msg  
     = next()
     | prev()
     | sub(Msg msg)
     | goto(int version)
     ;
```

## function debug {#salix-util-Debug-debug}

```rascal
App[DebugModel[&T]] debug(str appId,
                          &T() model, 
                          void(DebugModel[&T]) view, // // can't wrap view implicitly, because it'll lead to closures... 
                          &T(Msg, &T) upd,  
                          loc static)
```

## function wrapSubs {#salix-util-Debug-wrapSubs}

```rascal
Subs[DebugModel[&T]] wrapSubs(Subs[&T] subs)
```

## function wrapModel {#salix-util-Debug-wrapModel}

```rascal
DebugModel[&T]() wrapModel(&T() model, &T(Msg, &T) upd)
```

## function debugView {#salix-util-Debug-debugView}

```rascal
void debugView(DebugModel[&T] model, void(&T) subView)
```

## function debugUpdate {#salix-util-Debug-debugUpdate}

```rascal
DebugModel[&T] debugUpdate(Msg msg, DebugModel[&T] m)
```

