---
title: "module analysis::typepal::Messenger"
id: Messenger
slug: /Packages/org.rascalmpl.typepal/API/analysis/typepal/Messenger
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC61</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.typepal-0.15.2-RC11</div>

#### Usage

```rascal
import analysis::typepal::Messenger;
```

#### Dependencies
```rascal
import ParseTree;
import Message;
import Exception;
import String;
import Set;
import List;
import Location;
import util::IDEServices;
extend analysis::typepal::AType;
extend analysis::typepal::Exception;
```


## function sortMostPrecise {#analysis-typepal-Messenger-sortMostPrecise}

```rascal
list[Message] sortMostPrecise(list[Message] messages)
```

## function alreadyReported {#analysis-typepal-Messenger-alreadyReported}

```rascal
bool alreadyReported(list[Message] messages, loc src)
```

## function intercalateAnd {#analysis-typepal-Messenger-intercalateAnd}

```rascal
str intercalateAnd(list[str] strs)
```

## function intercalateOr {#analysis-typepal-Messenger-intercalateOr}

```rascal
str intercalateOr(list[str] strs)
```

## alias TypeProvider {#analysis-typepal-Messenger-TypeProvider}

```rascal
AType(Tree)
```

## function defaultGetType {#analysis-typepal-Messenger-defaultGetType}

```rascal
AType defaultGetType(Tree t)
```

## function fmt1 {#analysis-typepal-Messenger-fmt1}

```rascal
str fmt1(AType t, TypeProvider _)

str fmt1(str s, TypeProvider _)

str fmt1(int n, TypeProvider _)

str fmt1(list[value] vals, TypeProvider getType)

str fmt1(set[value] vals, TypeProvider getType)

str fmt1(Tree t, TypeProvider getType)

default str fmt1(value v, TypeProvider _)
```

## function interpolate {#analysis-typepal-Messenger-interpolate}

```rascal
str interpolate(str msg, TypeProvider getType, list[value] args)
```

## function fmt {#analysis-typepal-Messenger-fmt}

```rascal
Message fmt(str severity, value subject, str msg, TypeProvider getType, list[value] args, list[CodeAction] fixes = [], list[Message] causes = [])
```

## function toMessage {#analysis-typepal-Messenger-toMessage}

```rascal
Message toMessage(fm_error(value src, str msg, list[value] args, fixes=list[CodeAction] fixes, causes=list[Message] causes), TypeProvider getType)

Message toMessage(fm_warning(value src, str msg, list[value] args, fixes=list[CodeAction] fixes, causes=list[Message] causes), TypeProvider getType)

Message toMessage(fm_info(value src, str msg, list[value] args, fixes=list[CodeAction] fixes, causes=list[Message] causes), TypeProvider getType)
```

