---
title: "module analysis::typepal::refactor::Rename"
id: Rename
slug: /Packages/org.rascalmpl.typepal/API/analysis/typepal/refactor/Rename
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC61</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.typepal-0.15.2-RC11</div>

#### Usage

```rascal
import analysis::typepal::refactor::Rename;
```

#### Dependencies
```rascal
import analysis::diff::edits::TextEdits;
import analysis::typepal::FailMessage;
import analysis::typepal::Messenger;
import analysis::typepal::TModel;
import util::Monitor;
import Exception;
import IO;
import List;
import Map;
import Message;
import Node;
import ParseTree;
import Relation;
import Set;
```


## alias RenameResult {#analysis-typepal-refactor-Rename-RenameResult}

```rascal
tuple[list[FileSystemChange], set[Message]]
```

## alias Focus {#analysis-typepal-refactor-Rename-Focus}

```rascal
list[Tree]
```

## data Renamer {#analysis-typepal-refactor-Rename-Renamer}
Tracks state of renaming and provides helper functions.

```rascal
data Renamer  
     = renamer(
        void(FailMessage) msg
      , void(FileSystemChange) documentEdit
      , void(TextEdit) textEdit
      , RenameConfig() getConfig
    )
     ;
```


Tracks the state of the renaming, as an argument to every function of the rename framework.

* `msg` registers a [Fail Message](../../../../../..//Packages/org.rascalmpl.typepal/API/analysis/typepal/FailMessage.md#analysis-typepal-FailMessage-FailMessage). Registration of an [FailMessage-error](../../../../../..//Packages/org.rascalmpl.typepal/API/analysis/typepal/FailMessage.md#analysis-typepal-FailMessage-error) triggers premature termination of the renaming at the soonest possibility (typically before the next rename phase).
* `documentEdit` registers a [FileSystemChange](../../../../../..//Library/analysis/diff/edits/TextEdits.md#analysis-diff-edits-TextEdits-FileSystemChange), which represents a change required for the renaming.
* `textEdit` registers a [Text Edit](../../../../../..//Library/analysis/diff/edits/TextEdits.md#analysis-diff-edits-TextEdits-TextEdit), which represents a change required for the renaming. It is a convenience function that converts to a [FileSystemChange](../../../../../..//Library/analysis/diff/edits/TextEdits.md#analysis-diff-edits-TextEdits-FileSystemChange) internally, grouping [Text Edit](../../../../../..//Library/analysis/diff/edits/TextEdits.md#analysis-diff-edits-TextEdits-TextEdit)s to the same file where possible.
* `getConfig` retrieves the [RenameConfig](../../../../../..//Packages/org.rascalmpl.typepal/API/analysis/typepal/refactor/Rename.md#analysis-typepal-refactor-Rename-RenameConfig).

## data RenameConfig {#analysis-typepal-refactor-Rename-RenameConfig}
Language-specific configuration of identifier renaming.

```rascal
data RenameConfig  
     = rconfig(
        Tree(loc) parseLoc
      , TModel(Tree) tmodelForTree
      , TModel(loc) tmodelForLoc = TModel(loc l) { return tmodelForTree(parseLoc(l)); }
      , bool debug = false
      , str jobLabel = "Renaming"
    )
     ;
```


Configures the rename for a specific language, by giving the following mandatory arguments:
* `Tree parseLoc(loc l)`, which parses a file and returns a [Tree](../../../../../..//Library/ParseTree.md#ParseTree-Tree). Typically this would be `parse(#StartSymbol, l)`.
* `TModel tmodelForTree(Tree t)`, which type-checks a [Tree](../../../../../..//Library/ParseTree.md#ParseTree-Tree) and returns a [TModel](../../../../../..//Packages/org.rascalmpl.typepal/API/analysis/typepal/TModel.md#analysis-typepal-TModel-TModel). Typically, this would be [Collect And Solve](../../../../../..//Packages/org.rascalmpl.typepal/API/analysis/typepal/TypePal.md#analysis-typepal-TypePal-collectAndSolve).
The configuration also takes some optional arguments:
* `TModel tmodelForLoc(loc l)`, which type-checks a file given its `loc` instead of its parse tree. This can be useful when the file does not have to be parsed to produce a [TModel](../../../../../..//Packages/org.rascalmpl.typepal/API/analysis/typepal/TModel.md#analysis-typepal-TModel-TModel), for example when it had already been type-checked just before starting the renaming. Defaults to `tmodelForTree(parseLoc(l))`.
* `bool debug`, which indicates whether debug output should be printed during the renaming. Defaults to `false`.
*`str jobLabel`, which can be used to change the base label of the rename progress bar. Defaults to `"Renaming"`.

## function sortDocEdits {#analysis-typepal-refactor-Rename-sortDocEdits}

Sorts ((analysis::diff::edits::TextEdits::FileSystemChange))s.

```rascal
list[FileSystemChange] sortDocEdits(list[FileSystemChange] edits)
```


Applying edits through [ExecuteTextEdits](../../../../../..//Library/analysis/diff/edits/ExecuteTextEdits.md) should happen in a specific order.
Specifically, files should be created before they can be modified, and after renaming them, modifications/deletions should refer to the new name.
This functions sorts edits in the following order.

1. [created](../../../../../..//Library/analysis/diff/edits/FileSystemChanges.md#analysis-diff-edits-FileSystemChanges-created)
2. [changed](../../../../../..//Library/analysis/diff/edits/FileSystemChanges.md#analysis-diff-edits-FileSystemChanges-changed)
3. [renamed](../../../../../..//Library/analysis/diff/edits/FileSystemChanges.md#analysis-diff-edits-FileSystemChanges-renamed)
4. [removed](../../../../../..//Library/analysis/diff/edits/FileSystemChanges.md#analysis-diff-edits-FileSystemChanges-removed)

## function rename {#analysis-typepal-refactor-Rename-rename}

Renames the identifier under the cursor to `newName` and returns the required ((analysis::diff::edits::TextEdits::FileSystemChange))s and ((Message::Message))s.

```rascal
RenameResult rename(
        Focus cursor
      , str newName
      , RenameConfig config)
```


Renames the identifier under the cursor (represented as a Focus) to `newName`, given a specific [RenameConfig](../../../../../..//Packages/org.rascalmpl.typepal/API/analysis/typepal/refactor/Rename.md#analysis-typepal-refactor-Rename-RenameConfig).
This renaming uses [TModel](../../../../../..//Packages/org.rascalmpl.typepal/API/analysis/typepal/TModel.md#analysis-typepal-TModel-TModel)s produced by the type-checker.

The rename framework provides a default implementation, which can be selectively extended for languages that require different rename behaviour than the default. These functions constitute the implementation of renaming:
* [getCursorDefinitions](../../../../../..//Packages/org.rascalmpl.typepal/API/analysis/typepal/refactor/Rename.md#analysis-typepal-refactor-Rename-getCursorDefinitions)
* [findOccurrenceFiles](../../../../../..//Packages/org.rascalmpl.typepal/API/analysis/typepal/refactor/Rename.md#analysis-typepal-refactor-Rename-findOccurrenceFiles)
* [findAdditionalDefinitions](../../../../../..//Packages/org.rascalmpl.typepal/API/analysis/typepal/refactor/Rename.md#analysis-typepal-refactor-Rename-findAdditionalDefinitions)
* [validateNewNameOccurrences](../../../../../..//Packages/org.rascalmpl.typepal/API/analysis/typepal/refactor/Rename.md#analysis-typepal-refactor-Rename-validateNewNameOccurrences)
* [renameDefinition](../../../../../..//Packages/org.rascalmpl.typepal/API/analysis/typepal/refactor/Rename.md#analysis-typepal-refactor-Rename-renameDefinition)
* [renameUses](../../../../../..//Packages/org.rascalmpl.typepal/API/analysis/typepal/refactor/Rename.md#analysis-typepal-refactor-Rename-renameUses)
* [nameLocation](../../../../../..//Packages/org.rascalmpl.typepal/API/analysis/typepal/refactor/Rename.md#analysis-typepal-refactor-Rename-nameLocation)

#### Pitfalls


* Since the [RenameConfig](../../../../../..//Packages/org.rascalmpl.typepal/API/analysis/typepal/refactor/Rename.md#analysis-typepal-refactor-Rename-RenameConfig) that this function passes to the various hooks contains state and caches, it should never escape the scope of a single invoation of rename. Instead, it should always be accessed via [Renamer](../../../../../..//Packages/org.rascalmpl.typepal/API/analysis/typepal/refactor/Rename.md#analysis-typepal-refactor-Rename-renamer)'s `getConfig`.
* The renaming highly depends on a type-check function `TModel(Tree)`. If such a function does not exist, this framework cannot function.

## function _rename {#analysis-typepal-refactor-Rename-_rename}

```rascal
RenameResult _rename(
        Focus cursor
      , str newName
      , RenameConfig config)
```

## function defNameLocations {#analysis-typepal-refactor-Rename-defNameLocations}

Compute locations of names of `defs` in `tr`.

```rascal
map[Define, loc] defNameLocations(Tree tr, set[Define] defs, Renamer _r)
```

## function getCursorDefinitions {#analysis-typepal-refactor-Rename-getCursorDefinitions}

Computes ((Define))(s) for the name under `cursor`.

```rascal
default set[Define] getCursorDefinitions(Focus cursor, Tree(loc) _getTree, TModel(Tree) getModel, Renamer r)
```

## function findOccurrenceFiles {#analysis-typepal-refactor-Rename-findOccurrenceFiles}

Computes in which files occurrences of `cursorDefs` and `newName` *might* occur (over-approximation). This is not supposed to call the type-checker on any file for performance reasons.

```rascal
default tuple[set[loc] defFiles, set[loc] useFiles, set[loc] newNameFiles] findOccurrenceFiles(set[Define] cursorDefs, Focus cursor, str newName, Tree(loc) _getTree, Renamer r)
```

#### Pitfalls

For any file in `defFiles + useFiles`, the framework calls `RenameConfig::tmodelForLoc`. If type-cehcking is expensive and this function over-approximates by a large margin, the performance of the renaming might degrade.

## function findAdditionalDefinitions {#analysis-typepal-refactor-Rename-findAdditionalDefinitions}

Computes additional definitions (e.g. overloads of `cursorDefs`) in a single file.

```rascal
default set[Define] findAdditionalDefinitions(set[Define] _cursorDefs, Tree _tr, TModel _tm, Renamer _r)
```

## function validateNewNameOccurrences {#analysis-typepal-refactor-Rename-validateNewNameOccurrences}

Validates for a single file with occurrences of `newName` that, when renaming all occurrences of `cursorDefs` to `newName`, no problems will be introduced.

```rascal
default void validateNewNameOccurrences(set[Define] cursorDefs, str newName, Tree tr, Renamer r)
```

#### Examples

This could be used to detect many kinds of problems, e.g. static errors and semantic changes due to shadowing or overloading.

## function renameDefinition {#analysis-typepal-refactor-Rename-renameDefinition}

Renames a single ((Define)) `_d `with its name at `nameLoc`, defined in ((TModel)) `_tm`, to `newName`, by producing corresponding ((FileSystemChange))s.

```rascal
default void renameDefinition(Define _d, loc nameLoc, str newName, TModel _tm, Renamer r)
```

## function renameUses {#analysis-typepal-refactor-Rename-renameUses}

{Renames all uses of `defs` in a single file/((TModel)) `tm`, by producing corresponding ((FileSystemChange))s.}

```rascal
default void renameUses(set[Define] defs, str newName, TModel tm, Renamer r)
```

## function nameLocation {#analysis-typepal-refactor-Rename-nameLocation}

Finds the location of the identifier within definition ((ParseTree::Tree)) `t` corresponding to ((Define)) `d`, where `t.src == d.defined`.

```rascal
default loc nameLocation(Tree t, Define d)
```

