---
title: "module analysis::typepal::TModel"
id: TModel
slug: /Packages/org.rascalmpl.typepal/API/analysis/typepal/TModel
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC71</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.typepal-0.15.2-RC16</div>

#### Usage

```rascal
import analysis::typepal::TModel;
```

#### Dependencies
```rascal
import String;
import Message;
import Node;
import IO;
import analysis::typepal::Version;
```


## data IdRole {#analysis-typepal-TModel-IdRole}

```rascal
data IdRole  
     = variableId()
     ;
```

## function prettyRole {#analysis-typepal-TModel-prettyRole}

```rascal
str prettyRole(IdRole idRole)
```

## data ScopeRole {#analysis-typepal-TModel-ScopeRole}

```rascal
data ScopeRole  
     = anonymousScope()
     ;
```

## data Use {#analysis-typepal-TModel-Use}

```rascal
data Use  
     = use(str id, str orgId, loc occ, loc scope, set[IdRole] idRoles)
     | useq(list[str] ids, str orgId, loc occ, loc scope, set[IdRole] idRoles, set[IdRole] qualifierRoles)
     ;
```

## alias Uses {#analysis-typepal-TModel-Uses}

```rascal
list[Use]
```

## function getOrgId {#analysis-typepal-TModel-getOrgId}

```rascal
str getOrgId(Use u)

str getOrgId(Define d)
```

## data ReferPath {#analysis-typepal-TModel-ReferPath}

```rascal
data ReferPath  
     = referToDef(Use use, PathRole pathRole)
     | referToType(loc occ, loc scope, PathRole pathRole)
     ;
```

## alias ReferPaths {#analysis-typepal-TModel-ReferPaths}

```rascal
set[ReferPath]
```

## data DefInfo {#analysis-typepal-TModel-DefInfo}

```rascal
data DefInfo  
     = noDefInfo()
     ;
```

## alias Define {#analysis-typepal-TModel-Define}

```rascal
tuple[loc scope, str id, str orgId, IdRole idRole, loc defined, DefInfo defInfo]
```

## alias Defines {#analysis-typepal-TModel-Defines}

```rascal
set[Define]
```

## alias Scopes {#analysis-typepal-TModel-Scopes}

```rascal
map[loc inner, loc outer]
```

## alias Paths {#analysis-typepal-TModel-Paths}

```rascal
rel[loc from, PathRole pathRole, loc to]
```

## data TypePalConfig {#analysis-typepal-TModel-TypePalConfig}

```rascal
data TypePalConfig  
     = tconfig()
     ;
```

## data TModel {#analysis-typepal-TModel-TModel}

```rascal
data TModel (
    str version = getCurrentTplVersion(),
    Defines defines = {},
    Scopes scopes = (),
    Paths paths = {},
    ReferPaths referPaths = {},
    Uses uses = [],
    map[loc, map[str, rel[IdRole idRole, loc defined]]] definesMap = (),
    str modelName = "",
    map[str,loc] moduleLocs = (),
    set[Calculator] calculators = {},
    map[loc,AType] facts = (),
    map[loc,AType] specializedFacts = (),
    set[Requirement] requirements = {},
    rel[loc, loc] useDef = {},
    list[Message] messages = [],
    map[str,value] store = (),
    map[loc, Define] definitions = (),
    map[loc,loc] logical2physical = (),
    bool usesPhysicalLocs = false, // Are locations in physical format?
    TypePalConfig config = tconfig()
) 
     = tmodel()
     ;
```

## function printTModel {#analysis-typepal-TModel-printTModel}

```rascal
void printTModel(TModel tm)
```

