---
title: "module analysis::typepal::AType"
id: AType
slug: /Packages/org.rascalmpl.typepal/API/analysis/typepal/AType
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC71</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.typepal-0.15.2-RC18</div>

#### Usage

```rascal
import analysis::typepal::AType;
```

#### Dependencies
```rascal
import List;
extend analysis::typepal::GetLoc;
extend analysis::typepal::TModel;
```


## data AType {#analysis-typepal-AType-AType}

```rascal
data AType  
     = tvar(loc tname)
     | lazyLub(list[AType] atypes)
     | atypeList(list[AType] atypes)
     | overloadedAType(rel[loc, IdRole, AType] overloads)
     ;
```

## function isOverloadedAType {#analysis-typepal-AType-isOverloadedAType}

```rascal
bool isOverloadedAType(overloadedAType(rel[loc, IdRole, AType] overloads))

default bool isOverloadedAType(AType _)
```

## function lazyLub {#analysis-typepal-AType-lazyLub}

```rascal
AType lazyLub([*AType atypes1, lazyLub([*AType atypes2]), *AType atypes3])

AType lazyLub([*AType atypes1, AType atypea, *AType atypes2, AType atypeb, *AType atypes3])

AType lazyLub([AType atype])
```

## function flatten {#analysis-typepal-AType-flatten}

```rascal
rel[loc, IdRole, AType] flatten(rel[loc, IdRole, AType] overloads)
```

## function containsNestedOverloading {#analysis-typepal-AType-containsNestedOverloading}

```rascal
bool containsNestedOverloading(rel[loc, IdRole, AType] overloads)
```

## function overloadedAType {#analysis-typepal-AType-overloadedAType}

```rascal
AType overloadedAType(rel[loc, IdRole, AType] overloads)
```

## function prettyAType {#analysis-typepal-AType-prettyAType}

```rascal
str prettyAType(tvar(loc tname))

str prettyAType(lazyLub(list[AType] atypes))

str prettyAType(atypeList(list[AType] atypes))

default str prettyAType(overloadedAType(rel[loc, IdRole, AType] overloads))

default str prettyAType(AType tp)
```

## function itemizeLocs {#analysis-typepal-AType-itemizeLocs}

```rascal
str itemizeLocs(set[loc] locs)
```

