---
title: "module analysis::typepal::StringSimilarity"
id: StringSimilarity
slug: /Packages/org.rascalmpl.typepal/API/analysis/typepal/StringSimilarity
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC71</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.typepal-0.15.2-RC18</div>

#### Usage

```rascal
import analysis::typepal::StringSimilarity;
```

#### Dependencies
```rascal
import List;
import IO;
import Location;
import Set;
import String;
import analysis::typepal::ConfigurableScopeGraph;
```


## function min {#analysis-typepal-StringSimilarity-min}

Tryadic minimum function on integers

```rascal
int min(int a, int b, int c)
```

## function lev {#analysis-typepal-StringSimilarity-lev}

Calculate the Levenshtein distance of 2 strings

```rascal
int lev(str a, str b)
```

## alias WordSim {#analysis-typepal-StringSimilarity-WordSim}

WordSim represents one word from the vocabulary and its similariy to the original word

```rascal
tuple[str word, int sim]
```

## function similarWords {#analysis-typepal-StringSimilarity-similarWords}

Compute list of words from vocabulary, that are similar to give word w with at most maxDistance edits

```rascal
list[str] similarWords(str w, set[str] vocabulary, int maxDistance)
```

## function similarNames {#analysis-typepal-StringSimilarity-similarNames}

Find in TModel tm, names similar to Use u. Max edit distance comes from TypePal Configuration.

```rascal
list[str] similarNames(Use u, TModel tm)
```

# Tests
## test levCommutative {#analysis-typepal-StringSimilarity-levCommutative}

```rascal
test bool levCommutative(str a, str b) = lev(a, b) == lev(b, a);
```

## test levLeftAdditive {#analysis-typepal-StringSimilarity-levLeftAdditive}

```rascal
test bool levLeftAdditive(str a, str b, str c) = lev(a, b) == lev(c + a, c + b);
```

## test lev1 {#analysis-typepal-StringSimilarity-lev1}

```rascal
test bool lev1() = lev("kitten", "sitting") == 3;
```

## test lev2 {#analysis-typepal-StringSimilarity-lev2}

```rascal
test bool lev2() = lev("kelm", "hello") == 3;
```

## test lev3 {#analysis-typepal-StringSimilarity-lev3}

```rascal
test bool lev3() = lev("hello", "hella") == 1;
```

## test lev4 {#analysis-typepal-StringSimilarity-lev4}

```rascal
test bool lev4() = lev("hello", "") == 5;
```

## test lev5 {#analysis-typepal-StringSimilarity-lev5}

```rascal
test bool lev5() = lev("", "hello") == 5;
```

## test lev6 {#analysis-typepal-StringSimilarity-lev6}

```rascal
test bool lev6() = lev("aap", "noot") == 4;
```

## test lev7 {#analysis-typepal-StringSimilarity-lev7}

```rascal
test bool lev7() = lev("page", "pope") == 2;
```

## test lev8 {#analysis-typepal-StringSimilarity-lev8}

```rascal
test bool lev8() = lev("december", "january") == 8;
```

## test lev9 {#analysis-typepal-StringSimilarity-lev9}

```rascal
test bool lev9() = lev("march", "may") == 3;
```

