---
title: "module analysis::typepal::FailMessage"
id: FailMessage
slug: /Packages/org.rascalmpl.rascal/API/analysis/typepal/FailMessage
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC54</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.rascal-0.41.0-RC54</div>

#### Usage

```rascal
import analysis::typepal::FailMessage;
```

#### Dependencies
```rascal
import Message;
import String;
import util::IDEServices;
```


## data FailMessage {#analysis-typepal-FailMessage-FailMessage}

```rascal
data FailMessage (list[CodeAction] fixes = []) 
     = fm_error(value src, str msg, list[value] args)
     | fm_warning(value src, str msg, list[value] args)
     | fm_info(value src, str msg, list[value] args)
     ;
```

## function error {#analysis-typepal-FailMessage-error}

```rascal
FailMessage error(value src, str msg, value args..., list[CodeAction] fixes=[])
```

## function warning {#analysis-typepal-FailMessage-warning}

```rascal
FailMessage warning(value src, str msg, value args..., list[CodeAction] fixes=[])
```

## function info {#analysis-typepal-FailMessage-info}

```rascal
FailMessage info(value src, str msg, value args..., list[CodeAction] fixes=[])
```

## function escapePercent {#analysis-typepal-FailMessage-escapePercent}

```rascal
str escapePercent(str s)
```

## function convert {#analysis-typepal-FailMessage-convert}

```rascal
FailMessage convert(m: error(str msg, loc at))

FailMessage convert(m: warning(str msg, loc at))

FailMessage convert(m:info(str msg, loc at))
```

