---
title: "TypePal: Name and Type Analysis Made Easy"
details:
  - Overview
  - PocketCalculator
  - ConceptsAndDefinitions
  - Architecture
  - Reporting
  - Collector
  - Solver
  - Configuration
  - Utilities
  - RenameRefactoring
  - Examples
---
<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC54</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.rascal-0.41.0-RC54</div>

      
#### Synopsis

TypePal is a framework for name analysis, type checking and type inference

#### Description

Many type checkers have already been written in Rascal with good results. However, type checkers for different languages have a lot in common and address similar
questions:

* How to handle declarations of names, in particular their scope and uses?
* How to distinguish the roles names can play, e.g., names of functions, data types, labels, constants or variables?
* How to handle imports and multiple name spaces?
* How to associate requirements/constraints relevant for type checking with the syntax definition of the language being type checked?
* How to represent the types that occur in a program?
* How to handle global or local type inference?
* How to handle overloading?
* How to give precise error messages (and avoid spurious messages)?
* How to extract information that is useful for later compiler stages or the IDE for, 
  e.g., code generation, use-def information or name completion?
  
TypePal is a Rascal framework that addresses the above questions and we describe here all its concepts, architecture and features
and also show some examples:
 
* [Overview](../../../Packages/org.rascalmpl.rascal/TypePal/Overview/index.md)
* [Pocket Calculator](../../../Packages/org.rascalmpl.rascal/TypePal/PocketCalculator/index.md)
* [Concepts And Definitions](../../../Packages/org.rascalmpl.rascal/TypePal/ConceptsAndDefinitions/index.md)
* [Architecture](../../../Packages/org.rascalmpl.rascal/TypePal/Architecture/index.md)
* [Reporting](../../../Packages/org.rascalmpl.rascal/TypePal/Reporting/index.md)
* [Collector](../../../Packages/org.rascalmpl.rascal/TypePal/Collector/index.md)
* [Solver](../../../Packages/org.rascalmpl.rascal/TypePal/Solver/index.md)
* [Configuration](../../../Packages/org.rascalmpl.rascal/TypePal/Configuration/index.md)
* [Utilities](../../../Packages/org.rascalmpl.rascal/TypePal/Utilities/index.md)
* [Rename Refactoring](../../../Packages/org.rascalmpl.rascal/TypePal/RenameRefactoring/index.md)
* [Examples](../../../Packages/org.rascalmpl.rascal/TypePal/Examples/index.md)


