---
title: "module analysis::typepal::TestFramework"
id: TestFramework
slug: /Packages/org.rascalmpl.typepal/API/analysis/typepal/TestFramework
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC61</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.typepal-0.15.2-RC8</div>

#### Usage

```rascal
import analysis::typepal::TestFramework;
```

#### Dependencies
```rascal
import ParseTree;
import IO;
import String;
import Set;
import Map;
import List;
import util::Benchmark;
extend analysis::typepal::Messenger;
extend analysis::typepal::TypePal;
```


## syntax TTL_id {#analysis-typepal-TestFramework-TTL_id}

```rascal
lexical TTL_id = ([A-Z][a-zA-Z0-9]* !>> [a-zA-Z0-9]) \ TTL_Reserved;
```

## syntax TTL_StringCharacter {#analysis-typepal-TestFramework-TTL_StringCharacter}

```rascal
lexical TTL_StringCharacter
    = "\\" [\" \' \< \> \\ b f n r t]  
    | ![\" \' \< \> \\]
    | [\n][\ \t \u00A0 \u1680 \u2000-\u200A \u202F \u205F \u3000]* [\'] // margin 
    ;
```

## syntax TTL_String {#analysis-typepal-TestFramework-TTL_String}

```rascal
lexical TTL_String = "\"" TTL_StringCharacter*  "\"";
```

## syntax TTL_Reserved {#analysis-typepal-TestFramework-TTL_Reserved}

```rascal
keyword TTL_Reserved = "test" | "expect" ;
```

## syntax TTL_Layout {#analysis-typepal-TestFramework-TTL_Layout}

```rascal
layout TTL_Layout = TTL_WhitespaceAndComment* !>> [\ \t\n\r];
```

## syntax TTL_WhitespaceAndComment {#analysis-typepal-TestFramework-TTL_WhitespaceAndComment}

```rascal
lexical TTL_WhitespaceAndComment 
   = [\ \t\n\r]
   | @category="Comment" ws2: "@@" ![\n]+ $
   | @category="Comment" ws3: "\<@@" (![@] | "@" !>> "@" | "@@" !>> [\>])*  "@@\>"
   ;
```

## syntax TTL {#analysis-typepal-TestFramework-TTL}

```rascal
start syntax TTL = ttl: TTL_TestItem* items ;
```

## syntax TTL_Token {#analysis-typepal-TestFramework-TTL_Token}

```rascal
lexical TTL_Token 
    = ![\]] 
    | "]" !<< "]" !>> "]"
    ;
```

## syntax TTL_TestItem {#analysis-typepal-TestFramework-TTL_TestItem}

```rascal
syntax TTL_TestItem
    = "test" TTL_id name "[[" TTL_Token* tokens "]]" TTL_Expect expect
    ;
```

## syntax TTL_Expect {#analysis-typepal-TestFramework-TTL_Expect}

```rascal
syntax TTL_Expect
    = none: ()
    | "expect" "{" {TTL_String ","}* messages "}"
    ;
```

## data Tree {#analysis-typepal-TestFramework-Tree}

```rascal
data Tree (loc src = |unknown:///|)
```

## function matches {#analysis-typepal-TestFramework-matches}

```rascal
bool matches(str subject, str pat)
```

## function spinChar {#analysis-typepal-TestFramework-spinChar}

```rascal
str spinChar(int n)
```

## function runTests {#analysis-typepal-TestFramework-runTests}

```rascal
bool runTests(list[loc] suites, type[&T<:Tree] begin, TModel(Tree t) getModel, bool verbose = false, set[str] runOnly = {}, str runName = "")
```

## function extractTests {#analysis-typepal-TestFramework-extractTests}

```rascal
lrel[&T<:Tree, set[str]] extractTests(list[loc] suites, type[&T<:Tree] begin)
```

## function relocate {#analysis-typepal-TestFramework-relocate}

```rascal
&T<:Tree relocate(&T<:Tree t, loc container)

loc relocate(loc parsed_in_container, loc container)
```

