---
title: "module analysis::typepal::ConfigurableScopeGraph"
id: ConfigurableScopeGraph
slug: /Packages/org.rascalmpl.typepal/API/analysis/typepal/ConfigurableScopeGraph
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC61</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.typepal-0.15.2-RC9</div>

#### Usage

```rascal
import analysis::typepal::ConfigurableScopeGraph;
```

#### Dependencies
```rascal
extend analysis::typepal::Exception;
extend analysis::typepal::ISolver;
import IO;
import Set;
import Map;
import util::Reflective;
import String;
extend ParseTree;
import analysis::typepal::StringSimilarity;
```


## function defaultGetMinAType {#analysis-typepal-ConfigurableScopeGraph-defaultGetMinAType}

```rascal
AType defaultGetMinAType()
```

## function defaultGetMaxAType {#analysis-typepal-ConfigurableScopeGraph-defaultGetMaxAType}

```rascal
AType defaultGetMaxAType()
```

## function defaultGetLub {#analysis-typepal-ConfigurableScopeGraph-defaultGetLub}

```rascal
AType defaultGetLub(AType atype1, AType atype2)
```

## function defaultIsSubType {#analysis-typepal-ConfigurableScopeGraph-defaultIsSubType}

```rascal
bool defaultIsSubType(AType atype1, AType atype2)
```

## function defaultMayOverload {#analysis-typepal-ConfigurableScopeGraph-defaultMayOverload}

```rascal
bool defaultMayOverload (set[loc] _, map[loc, Define] _)
```

## function defaultInstantiateTypeParameters {#analysis-typepal-ConfigurableScopeGraph-defaultInstantiateTypeParameters}

```rascal
AType defaultInstantiateTypeParameters(Tree _, AType def, AType ins, AType act, Solver _)
```

## function defaultGetTypeNamesAndRole {#analysis-typepal-ConfigurableScopeGraph-defaultGetTypeNamesAndRole}

```rascal
tuple[list[str] typeNames, set[IdRole] idRoles] defaultGetTypeNamesAndRole(AType _)
```

## function defaultGetTypeInNamelessType {#analysis-typepal-ConfigurableScopeGraph-defaultGetTypeInNamelessType}

```rascal
AType defaultGetTypeInNamelessType(AType _, Tree _, loc _, Solver _)
```

## function defaultGetTypeInTypeFromDefine {#analysis-typepal-ConfigurableScopeGraph-defaultGetTypeInTypeFromDefine}

```rascal
AType defaultGetTypeInTypeFromDefine(Define _, str _, set[IdRole] _, Solver _)
```

## function defaultNormalizeName {#analysis-typepal-ConfigurableScopeGraph-defaultNormalizeName}

```rascal
str defaultNormalizeName(str s)
```

## function defaultReportUnused {#analysis-typepal-ConfigurableScopeGraph-defaultReportUnused}

```rascal
bool defaultReportUnused (loc _, TModel _)
```

## function reduceToURIChars {#analysis-typepal-ConfigurableScopeGraph-reduceToURIChars}

```rascal
str reduceToURIChars(str s)
```

## function defaultLogicalLoc {#analysis-typepal-ConfigurableScopeGraph-defaultLogicalLoc}

```rascal
loc defaultLogicalLoc(Define def, str _modelName, PathConfig _pcfg)
```

## function defaultSimilarNames {#analysis-typepal-ConfigurableScopeGraph-defaultSimilarNames}

```rascal
list[str] defaultSimilarNames(Use u, TModel tm)
```

## data TypePalConfig {#analysis-typepal-ConfigurableScopeGraph-TypePalConfig}

```rascal
data TypePalConfig (
        Accept (loc def, Use use, Solver s) isAcceptableSimple
            = defaultIsAcceptableSimple,
        Accept (loc def, Use use, Solver s) isAcceptableQualified
            = defaultIsAcceptableQualified,
        Accept (loc defScope, loc def, Use use, PathRole pathRole, Solver s) isAcceptablePath
            = defaultIsAcceptablePath
        )
```

```rascal
data TypePalConfig (
        bool verbose               = false,

        PathConfig typepalPathConfig = pathConfig(),

        AType() getMinAType
            = AType (){  throw TypePalUsage("`getMinAType()` called but is not specified in TypePalConfig"); },

        AType() getMaxAType
            = AType (){ throw TypePalUsage("`getMaxAType()` called but is not specified in TypePalConfig"); },

        bool (AType t1, AType t2) isSubType
            = bool (AType atype1, AType atype2) { throw TypePalUsage("`subtype(<atype1>, <atype2>)` called but `isSubType` is not specified in TypePalConfig"); },

        AType (AType t1, AType t2) getLub
            = AType (AType atype1, AType atype2){ throw TypePalUsage("`lub(<atype1>, <atype2>)` called but `getLub` is not specified in TypePalConfig"); },

        bool (set[loc] defs, map[loc, Define] defines) mayOverload
            = bool (set[loc] _, map[loc, Define] _) { return false; },

        bool (IdRole idRole) isInferrable
            = bool(IdRole _) { return false; },

        str(str) normalizeName
            = defaultNormalizeName,

        AType (Tree selector, AType def, AType ins, AType act, Solver s) instantiateTypeParameters
            = AType(Tree _, AType _, AType _, AType act, Solver _){ return act; },

        tuple[list[str] typeNames, set[IdRole] idRoles] (AType atype) getTypeNamesAndRole
            = tuple[list[str] typeNames, set[IdRole] idRoles](AType _){
                throw TypePalUsage("`useViaType` used without definition of `getTypeNamesAndRole`");
            },

        AType (Define containerDef, str selectorName, set[IdRole] idRolesSel, Solver s) getTypeInTypeFromDefine
            = AType (Define _, str _, set[IdRole] _, Solver _) { throw NoBinding(); },

        AType(AType containerType, Tree selector, loc scope, Solver s) getTypeInNamelessType
            = AType(AType _, Tree _, loc _, Solver _){
                throw TypePalUsage("`useViaType` used without definition of `getTypeInNamelessType`");
            },

        TModel(map[str,Tree] namedTrees, TModel tm) preSolver = TModel(map[str,Tree] _, TModel tm) { return tm; },
        void (map[str,Tree] namedTrees, Solver s) postSolver  = void(map[str,Tree] _, Solver _) { return ; },

        bool(loc def, TModel tm) reportUnused = defaultReportUnused,

        loc (Define def, str modelName, PathConfig pcfg) createLogicalLoc = defaultLogicalLoc,

        list[str] (Use u, TModel tm) similarNames = defaultSimilarNames,

        bool enableErrorFixes = true,

        int cutoffForNameSimilarity = 3
    )
```

## data Accept {#analysis-typepal-ConfigurableScopeGraph-Accept}

```rascal
data Accept  
     = acceptBinding()
     | ignoreContinue()
     | ignoreSkipPath()
     ;
```

## function defaultIsAcceptableSimple {#analysis-typepal-ConfigurableScopeGraph-defaultIsAcceptableSimple}

```rascal
Accept defaultIsAcceptableSimple(loc candidate, Use use, Solver _)
```

## function defaultIsAcceptablePath {#analysis-typepal-ConfigurableScopeGraph-defaultIsAcceptablePath}

```rascal
Accept defaultIsAcceptablePath(loc defScope, loc def, Use use, PathRole _, Solver _)
```

## function defaultIsAcceptableQualified {#analysis-typepal-ConfigurableScopeGraph-defaultIsAcceptableQualified}

```rascal
Accept defaultIsAcceptableQualified(loc _, Use _, Solver _)
```

## function checkPaths {#analysis-typepal-ConfigurableScopeGraph-checkPaths}

```rascal
default bool checkPaths(TModel tm, loc from, loc to, PathRole pathRole, bool(TModel,loc) pred)
```

## function existsPath {#analysis-typepal-ConfigurableScopeGraph-existsPath}

```rascal
bool existsPath(TModel tm, loc from, loc to, PathRole pathRole)
```

## data ScopeGraph {#analysis-typepal-ConfigurableScopeGraph-ScopeGraph}

```rascal
data ScopeGraph  
     = scopegraph(
        set[loc] (Use u) lookup,
        void (Solver s) setSolver
    )
     ;
```

## function newScopeGraph {#analysis-typepal-ConfigurableScopeGraph-newScopeGraph}

```rascal
ScopeGraph newScopeGraph(TModel tm, TypePalConfig config)
```

