---
title: "module analysis::typepal::Collector"
id: Collector
slug: /Packages/org.rascalmpl.typepal/API/analysis/typepal/Collector
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.typepal-0.15.3</div>

#### Usage

```rascal
import analysis::typepal::Collector;
```

#### Dependencies
```rascal
import Node;
import Map;
import ParseTree;
import Set;
import Relation;
import IO;
import Type;
import Location;
import String;
import analysis::typepal::Version;
import analysis::typepal::Messenger;
extend analysis::typepal::ConfigurableScopeGraph;
extend analysis::typepal::ICollector;
```


## function dependenciesAslocList {#analysis-typepal-Collector-dependenciesAslocList}

```rascal
list[loc] dependenciesAslocList(list[value] dependencies)
```

## function isTypeVarFree {#analysis-typepal-Collector-isTypeVarFree}

```rascal
bool isTypeVarFree(AType t)
```

## function dependenciesAslocs {#analysis-typepal-Collector-dependenciesAslocs}

```rascal
list[loc] dependenciesAslocs(list[Tree] dependencies)
```

## data DefInfo {#analysis-typepal-Collector-DefInfo}

```rascal
data DefInfo  
     = defType(loc src)
     | defType(Tree tree)
     | defType(AType atype)
     | defTypeCall(list[loc] dependsOn, AType(Solver s) getAType)
     | defTypeLub(list[loc] dependsOn, list[loc] defines, list[AType(Solver s)] getATypes)
     ;
```

## function defType {#analysis-typepal-Collector-defType}

```rascal
DefInfo defType(list[Tree] dependsOn, AType(Solver s) getAType)
```

## function getDependencies {#analysis-typepal-Collector-getDependencies}

```rascal
list[loc] getDependencies(defType(loc src))

list[loc] getDependencies(defType(Tree tree))

list[loc] getDependencies(defType(AType atype))

default list[loc] getDependencies(DefInfo di)
```

## function defLub {#analysis-typepal-Collector-defLub}

```rascal
DefInfo defLub(list[Tree] dependsOn, AType(Solver s) getAType)
```

## function printDeps {#analysis-typepal-Collector-printDeps}

```rascal
void printDeps(list[loc] dependsOn, str indent, map[loc,AType] facts)
```

## data Requirement {#analysis-typepal-Collector-Requirement}

```rascal
data Requirement (bool eager = false) 
     = req(str rname, loc src,  list[loc] dependsOn, void(Solver s) preds)
     | reqEqual(str rname, value l, value r, list[loc] dependsOn, FailMessage fm)
     | reqComparable(str rname, value l, value r, list[loc] dependsOn, FailMessage fm)
     | reqSubtype(str rname, value l, value r, list[loc] dependsOn, FailMessage fm)
     | reqUnify(str rname, value l, value r, list[loc] dependsOn, FailMessage fm)
     | reqError (loc src, list[loc] dependsOn, FailMessage fm)
     | reqErrors(loc src, list[loc] dependsOn, list[FailMessage] fms)
     ;
```

## function getReqSrc {#analysis-typepal-Collector-getReqSrc}

```rascal
loc getReqSrc(Requirement req)
```

## function print {#analysis-typepal-Collector-print}

```rascal
void print(req(str rname, loc src,  list[loc] dependsOn, void(Solver s) preds), str indent, map[loc,AType] facts, bool full=true)

void print(req(str rname, loc src,  list[loc] dependsOn, void(Solver s) preds), str indent, map[loc,AType] facts, bool full=true)

void print(reqEqual(str rname, value l, value r, list[loc] dependsOn, FailMessage fm), str indent, map[loc,AType] facts, bool full=true)

void print(reqComparable(str rname, value l, value r, list[loc] dependsOn, FailMessage fm), str indent, map[loc,AType] facts, bool full=true)

void print(reqSubtype(str rname, value l, value r, list[loc] dependsOn, FailMessage fm), str indent, map[loc,AType] facts, bool full=true)

void print(reqUnify(str rname, value l, value r, list[loc] dependsOn, FailMessage fm), str indent, map[loc,AType] facts, bool full=true)

void print(reqError (loc src, list[loc] dependsOn, FailMessage fm), str indent, map[loc,AType] facts, bool full=true)

void print(reqErrors(loc src, list[loc] dependsOn, list[FailMessage] fms), str indent, map[loc,AType] facts, bool full=true)
```

## data Calculator {#analysis-typepal-Collector-Calculator}

```rascal
data Calculator  
     = calcType(loc src, AType atype)
     | calcLoc(loc src, list[loc] dependsOn)
     | calc(str cname, loc src, list[loc] dependsOn, AType(Solver s) getAType, bool eager=false)
     | calcLub(str cname, list[loc] srcs, list[loc] dependsOn, list[AType(Solver s)] getATypes, bool eager=false)
     ;
```

## function dependsOn {#analysis-typepal-Collector-dependsOn}

```rascal
list[loc] dependsOn(Calculator calc)
```

## function srcs {#analysis-typepal-Collector-srcs}

```rascal
list[loc] srcs(Calculator calc)
```

## function print {#analysis-typepal-Collector-print}

```rascal
void print(calcType(loc src, AType atype), str indent, map[loc,AType] facts, bool full=true)

void print(calcLoc(loc src, list[loc] dependsOn), str indent, map[loc,AType] facts, bool full=true)

void print(calc(str cname, loc src, list[loc] dependsOn, AType(Solver s) calculator), str indent, map[loc,AType] facts, bool full=true)

void print(calcLub(str cname, list[loc] srcs, list[loc] dependsOn, list[AType(Solver s)] getATypes), str indent, map[loc,AType] facts, bool full=true)

void print(tuple[loc scope, str id, IdRole idRole, loc defined, DefInfo defInfo] def, str indent, map[loc, AType] facts, bool full=true)
```

## function defaultCollector {#analysis-typepal-Collector-defaultCollector}

```rascal
Collector defaultCollector(Tree t)
```

## function newCollector {#analysis-typepal-Collector-newCollector}

```rascal
Collector newCollector(str modelName, Tree pt, TypePalConfig config)
```

## function convertLocs {#analysis-typepal-Collector-convertLocs}

```rascal
TModel convertLocs(TModel tm, map[loc,loc] locMap)
```

## function convertTModel2PhysicalLocs {#analysis-typepal-Collector-convertTModel2PhysicalLocs}

```rascal
TModel convertTModel2PhysicalLocs(TModel tm)
```

## function convertTModel2LogicalLocs {#analysis-typepal-Collector-convertTModel2LogicalLocs}

```rascal
TModel convertTModel2LogicalLocs(TModel tm, map[str,TModel] tmodels)
```

## function newCollector {#analysis-typepal-Collector-newCollector}

```rascal
Collector newCollector(str modelName, map[str,Tree] namedTrees, TypePalConfig config)
```

## function collect {#analysis-typepal-Collector-collect}

```rascal
void collect(Tree t1, Tree t2, Collector c)

void collect(Tree t1, Tree t2, Tree t3, Collector c)

void collect(Tree t1, Tree t2, Tree t3, Tree t4, Collector c)

void collect(Tree t1, Tree t2, Tree t3, Tree t4, Tree t5, Collector c)

void collect(Tree t1, Tree t2, Tree t3, Tree t4, Tree t5, Tree t6, Collector c)

void collect(Tree t1, Tree t2, Tree t3, Tree t4, Tree t5, Tree t6, Tree t7, Collector c)

void collect(Tree t1, Tree t2, Tree t3, Tree t4, Tree t5, Tree t6, Tree t7, Tree t8, Collector c)

void collect(Tree t1, Tree t2, Tree t3, Tree t4, Tree t5, Tree t6, Tree t7, Tree t8, Tree t9, Collector c)

void collect(list[Tree] currentTrees, Collector c)
```

## function collectArgs1 {#analysis-typepal-Collector-collectArgs1}

```rascal
void collectArgs1(list[Tree] args, Collector c)
```

## function collectArgs2 {#analysis-typepal-Collector-collectArgs2}

```rascal
void collectArgs2(list[Tree] args, Collector c)
```

## function collectArgsN {#analysis-typepal-Collector-collectArgsN}

```rascal
void collectArgsN(list[Tree] args, int delta, Collector c)
```

## function allSymbolsIgnored {#analysis-typepal-Collector-allSymbolsIgnored}

```rascal
bool allSymbolsIgnored(list[Symbol] symbols)
```

## function treeAsMessage {#analysis-typepal-Collector-treeAsMessage}

```rascal
str treeAsMessage(Tree t, int charLimit=120)
```

## function collect {#analysis-typepal-Collector-collect}

```rascal
default void collect(Tree currentTree, Collector c)
```

